<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Plan;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Plan::create([
            'name' => 'Basic',
            'description' => 'Basic plan with limited features',
            'price' => 9.99,
            'interval' => 'month',
            'max_users' => 1,
            'max_products' => 100,
            'is_active' => true,
            'features' => json_encode(['Basic Support', 'Limited Reports']),
        ]);

        Plan::create([
            'name' => 'Pro',
            'description' => 'Pro plan with extended features',
            'price' => 29.99,
            'interval' => 'month',
            'max_users' => 10,
            'max_products' => 1000,
            'is_active' => true,
            'features' => json_encode(['Priority Support', 'Advanced Reports', 'Multi-User']),
        ]);

        Plan::create([
            'name' => 'Enterprise',
            'description' => 'Enterprise plan with all features',
            'price' => 99.99,
            'interval' => 'month',
            'max_users' => 100,
            'max_products' => 10000,
            'is_active' => true,
            'features' => json_encode(['Dedicated Support', 'Custom Reports', 'Unlimited Users']),
        ]);
    }
}
